/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.containers.ContainerChestCustom;
import org.lwjgl.input.Mouse;

public class GuiCustomContainer
extends GuiContainer {
    private static final ResourceLocation backTexture = new ResourceLocation("customnpcs", "textures/gui/smallbg.png");
    private static final ResourceLocation tabsTexture = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation rowTexture = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    private static final ResourceLocation lockTexture = new ResourceLocation("textures/gui/widgets.png");
    private final ContainerChestCustom inventorySlots;
    private final int guiColor;
    private final int maxRows;
    private final int step;
    public int mouseWheel;
    private int row;
    private int yPos;
    private final int[] guiColorArr;
    private final boolean isMany;
    private boolean hoverScroll;
    private final String lock;
    private boolean isScrolling;

    public GuiCustomContainer(ContainerChestCustom container) {
        super((Container)container);
        this.field_146297_k = Minecraft.func_71410_x();
        this.inventorySlots = container;
        this.isMany = container.customChest.func_70302_i_() > 45;
        this.field_146291_p = false;
        this.lock = !container.customChest.func_174891_i().func_180160_a() ? container.customChest.func_174891_i().func_180159_b() : "";
        this.row = 0;
        this.maxRows = (int)Math.ceil((double)container.customChest.inventory.size() / 9.0) - 5;
        this.guiColor = container.customChest.guiColor;
        this.guiColorArr = container.customChest.guiColorArr;
        this.field_147000_g = 114 + this.inventorySlots.height;
        this.step = this.maxRows > 0 ? (int)(73.0f / (float)this.maxRows) : 0;
        this.isScrolling = false;
        this.resetSlots();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.guiColor == -1) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)((float)(this.guiColor >> 16 & 0xFF) / 255.0f), (float)((float)(this.guiColor >> 8 & 0xFF) / 255.0f), (float)((float)(this.guiColor & 0xFF) / 255.0f), (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(backTexture);
        int u = (this.field_146294_l - this.field_146999_f) / 2;
        int v = (this.field_146295_m - this.field_147000_g) / 2;
        int h = this.inventorySlots.height + 107;
        if (this.guiColorArr != null && this.guiColorArr.length > 1) {
            float r0 = (float)(this.guiColorArr[0] >> 16 & 0xFF) / 255.0f;
            float g0 = (float)(this.guiColorArr[0] >> 8 & 0xFF) / 255.0f;
            float b0 = (float)(this.guiColorArr[0] & 0xFF) / 255.0f;
            float r1 = (float)(this.guiColorArr[1] >> 16 & 0xFF) / 255.0f;
            float g1 = (float)(this.guiColorArr[1] >> 8 & 0xFF) / 255.0f;
            float b1 = (float)(this.guiColorArr[1] & 0xFF) / 255.0f;
            float s = 1.0f / (float)h;
            for (int i = 0; i < h; ++i) {
                float sd = (float)i * s;
                float r = r0 * (1.0f - sd) + r1 * sd;
                float g = g0 * (1.0f - sd) + g1 * sd;
                float b = b0 * (1.0f - sd) + b1 * sd;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
                if (i <= h - 4) {
                    this.func_73729_b(u, v + i, 0, i, 176, 1);
                    if (!this.isMany) continue;
                    this.func_73729_b(u + 172, v + i, 156, i, 20, 1);
                    continue;
                }
                this.func_73729_b(u, v + i, 0, 222 + i - h, 176, 1);
                if (!this.isMany) continue;
                this.func_73729_b(u + 172, v + i, 156, 222 + i - h, 20, 1);
            }
        } else {
            this.func_73729_b(u, v, 0, 0, 176, h - 4);
            this.func_73729_b(u, v + h - 4, 0, 218, 176, 4);
        }
        this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int s = 0; s < this.inventorySlots.field_75151_b.size(); ++s) {
            Slot slot = this.inventorySlots.func_75139_a(s);
            if (slot.field_75223_e <= 0 || slot.field_75221_f <= 0) continue;
            this.func_73729_b(u + slot.field_75223_e - 1, v + slot.field_75221_f - 1, 0, 0, 18, 18);
        }
        if (this.isMany) {
            this.field_146297_k.func_110434_K().func_110577_a(rowTexture);
            this.func_73729_b(u + 172, v + 17, 174, 17, 14, 86);
            this.func_73729_b(u + 172, v + 103, 174, 125, 14, 4);
        }
        if (!this.lock.isEmpty()) {
            this.field_146297_k.func_110434_K().func_110577_a(lockTexture);
            this.func_73729_b(u + 164 + (this.isMany ? 16 : 0), v - 8, 0, 146, 20, 20);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int b;
        int g;
        int r;
        TextComponentTranslation text = new TextComponentTranslation(this.inventorySlots.customChest.func_70005_c_(), new Object[0]);
        text.func_150256_b().func_150227_a(Boolean.valueOf(true));
        int color = -1;
        if (this.guiColor != -1 && (r = this.guiColor >> 16 & 0xFF) + (g = this.guiColor >> 8 & 0xFF) + (b = this.guiColor & 0xFF) > 384) {
            color = -16777216;
        }
        if (this.guiColorArr != null && (r = this.guiColorArr[0] >> 16 & 0xFF) + (g = this.guiColorArr[0] >> 8 & 0xFF) + (b = this.guiColorArr[0] & 0xFF) > 384) {
            color = -16777216;
        }
        this.field_146289_q.func_78276_b(text.func_150254_d(), 8, 6, color);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int v;
        int u;
        this.mouseWheel = Mouse.getDWheel();
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.hoverScroll = false;
        if (this.isMany) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
            u = (this.field_146294_l - this.field_146999_f) / 2;
            v = (this.field_146295_m - this.field_147000_g) / 2;
            this.field_146297_k.func_110434_K().func_110577_a(tabsTexture);
            float currentScroll = (float)this.row / (float)this.maxRows;
            int h = (int)(currentScroll * 73.0f);
            this.hoverScroll = mouseX >= (u += 173) && mouseX <= u + 12 && mouseY >= (v += 18 + h) && mouseY <= v + 15;
            this.func_73729_b(u, v, this.hoverScroll ? 244 : 232, 0, 12, 15);
            GlStateManager.func_179121_F();
            if (this.mouseWheel > 0) {
                this.resetRow(false);
            } else if (this.mouseWheel < 0) {
                this.resetRow(true);
            }
        }
        this.func_191948_b(mouseX, mouseY);
        if (!this.lock.isEmpty()) {
            u = (this.field_146294_l - this.field_146999_f) / 2 + 164 + (this.isMany ? 16 : 0);
            v = (this.field_146295_m - this.field_147000_g) / 2 - 8;
            if (mouseX >= u && mouseX <= u + 20 && mouseY >= v && mouseY <= v + 20) {
                ArrayList<String> textLines = new ArrayList<String>();
                textLines.add(new TextComponentTranslation("companion.owner", new Object[0]).func_150254_d() + ":");
                textLines.add(this.lock.length() < 1000 ? this.lock : this.lock.substring(0, 1000) + "...");
                this.func_146283_a(textLines, mouseX, mouseY);
            }
        }
    }

    public void func_146274_d() throws IOException {
        if (this.isScrolling) {
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (mouseY - this.yPos >= this.step) {
                this.resetRow(true);
                this.yPos = mouseY;
            } else if ((mouseY - this.yPos) * -1 >= this.step) {
                this.resetRow(false);
                this.yPos = mouseY;
            }
        }
        super.func_146274_d();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.resetSlots();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 200 || keyCode == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.resetRow(false);
        }
        if (keyCode == 208 || keyCode == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.resetRow(true);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.hoverScroll) {
            this.yPos = mouseY;
            this.isScrolling = true;
        } else if (this.isMany) {
            int u = 173 + (this.field_146294_l - this.field_146999_f) / 2;
            int v = 18 + (this.field_146295_m - this.field_147000_g) / 2;
            if (mouseX >= u && mouseX <= u + 11 && mouseY >= v && mouseY <= v + 88) {
                int h = mouseY - v;
                int r = h <= 7 ? 0 : (h >= 81 ? this.maxRows : (int)((double)this.maxRows * (double)h / 88.0));
                int old = this.row;
                if (r < 0) {
                    r = 0;
                }
                if (r > this.maxRows) {
                    r = this.maxRows;
                }
                if (old != r) {
                    this.row = r;
                    this.resetSlots();
                }
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.isScrolling) {
            this.isScrolling = false;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    private void resetRow(boolean bo) {
        if (!this.isMany) {
            return;
        }
        int old = this.row++;
        if (!bo) {
            --this.row;
        }
        if (this.row < 0) {
            this.row = 0;
        }
        if (this.row > this.maxRows) {
            this.row = this.maxRows;
        }
        if (old != this.row) {
            this.resetSlots();
        }
    }

    private void resetSlots() {
        if (!this.isMany) {
            return;
        }
        int m = this.row * 9;
        int n = m + 45;
        int i = -1;
        int t = this.inventorySlots.customChest.func_70302_i_();
        int u = 0;
        int e = t;
        if (t % 9 != 0) {
            e -= t % 9;
        }
        for (int s = 0; s < t; ++s) {
            Slot slot = this.inventorySlots.func_75139_a(s);
            if (s < m || s >= n) {
                slot.field_75223_e = -5000;
                slot.field_75221_f = -5000;
                continue;
            }
            ++i;
            if (s >= e) {
                u = (int)((9.0 - (double)t % 9.0) / 2.0 * 18.0);
            }
            slot.field_75223_e = 8 + u + i % 9 * 18;
            slot.field_75221_f = 18 + i / 9 * 18;
        }
    }
}

